% This script is used to apply the parameters generated with
% FailureTriggering.failureProcessing.

%  Author: F.L.J. van der Linden,
%  Revision(s): 23-07-2012 % first version
%  Copyright 2008-20012 DLR

%% Define Constants

Dymola_dsin = 'dsin.txt'; % dsin.txt generated by matlab from dsin.mat
ScriptName = 'SetFailures.txt'; % scrip generated by the modelica function FailureTriggering.failureProcessing
DymolaBlockName = 'FailureExample/DymolaBlock'; % Dymola block name in Simulink

%% Process Script to extract failure names
[FaultName,FaultValue,FaultDescription] = ProcessFailureScript(ScriptName);


%% get parameter Names from FaultExample.txt
[p,x0,pnames,x0names,inputnames,outputnames]=loaddsin(Dymola_dsin);

%% set fault parameters
for Faulti = 1:length(FaultName)
    disp([FaultName{Faulti}, ' = ' ,num2str(FaultValue(Faulti)),' : ',FaultDescription{Faulti}])
    p = setParameterByName(pnames, p, FaultName{Faulti}, FaultValue(Faulti));
end

setParametersFDsin(DymolaBlockName,pnames,p,x0names,x0)
